<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Conversations\V1\Service;

use Twilio\Options;
use Twilio\Values;

abstract class ConfigurationOptions {
    /**
     * @param string $defaultConversationCreatorRoleSid The role assigned to a
     *                                                  conversation creator when
     *                                                  they join a new conversation
     * @param string $defaultConversationRoleSid The role assigned to users when
     *                                           they are added to a conversation
     * @param string $defaultChatServiceRoleSid The service role assigned to users
     *                                          when they are added to the service
     * @param bool $reachabilityEnabled Whether the Reachability Indicator feature
     *                                  is enabled for this Conversations Service
     * @return UpdateConfigurationOptions Options builder
     */
    public static function update(string $defaultConversationCreatorRoleSid = Values::NONE, string $defaultConversationRoleSid = Values::NONE, string $defaultChatServiceRoleSid = Values::NONE, bool $reachabilityEnabled = Values::NONE): UpdateConfigurationOptions {
        return new UpdateConfigurationOptions($defaultConversationCreatorRoleSid, $defaultConversationRoleSid, $defaultChatServiceRoleSid, $reachabilityEnabled);
    }
}

class UpdateConfigurationOptions extends Options {
    /**
     * @param string $defaultConversationCreatorRoleSid The role assigned to a
     *                                                  conversation creator when
     *                                                  they join a new conversation
     * @param string $defaultConversationRoleSid The role assigned to users when
     *                                           they are added to a conversation
     * @param string $defaultChatServiceRoleSid The service role assigned to users
     *                                          when they are added to the service
     * @param bool $reachabilityEnabled Whether the Reachability Indicator feature
     *                                  is enabled for this Conversations Service
     */
    public function __construct(string $defaultConversationCreatorRoleSid = Values::NONE, string $defaultConversationRoleSid = Values::NONE, string $defaultChatServiceRoleSid = Values::NONE, bool $reachabilityEnabled = Values::NONE) {
        $this->options['defaultConversationCreatorRoleSid'] = $defaultConversationCreatorRoleSid;
        $this->options['defaultConversationRoleSid'] = $defaultConversationRoleSid;
        $this->options['defaultChatServiceRoleSid'] = $defaultChatServiceRoleSid;
        $this->options['reachabilityEnabled'] = $reachabilityEnabled;
    }

    /**
     * The conversation-level role assigned to a conversation creator when they join a new conversation. See the [Conversation Role](https://www.twilio.com/docs/conversations/api/role-resource) for more info about roles.
     *
     * @param string $defaultConversationCreatorRoleSid The role assigned to a
     *                                                  conversation creator when
     *                                                  they join a new conversation
     * @return $this Fluent Builder
     */
    public function setDefaultConversationCreatorRoleSid(string $defaultConversationCreatorRoleSid): self {
        $this->options['defaultConversationCreatorRoleSid'] = $defaultConversationCreatorRoleSid;
        return $this;
    }

    /**
     * The conversation-level role assigned to users when they are added to a conversation. See the [Conversation Role](https://www.twilio.com/docs/conversations/api/role-resource) for more info about roles.
     *
     * @param string $defaultConversationRoleSid The role assigned to users when
     *                                           they are added to a conversation
     * @return $this Fluent Builder
     */
    public function setDefaultConversationRoleSid(string $defaultConversationRoleSid): self {
        $this->options['defaultConversationRoleSid'] = $defaultConversationRoleSid;
        return $this;
    }

    /**
     * The service-level role assigned to users when they are added to the service. See the [Conversation Role](https://www.twilio.com/docs/conversations/api/role-resource) for more info about roles.
     *
     * @param string $defaultChatServiceRoleSid The service role assigned to users
     *                                          when they are added to the service
     * @return $this Fluent Builder
     */
    public function setDefaultChatServiceRoleSid(string $defaultChatServiceRoleSid): self {
        $this->options['defaultChatServiceRoleSid'] = $defaultChatServiceRoleSid;
        return $this;
    }

    /**
     * Whether the [Reachability Indicator](https://www.twilio.com/docs/chat/reachability-indicator) is enabled for this Conversations Service. The default is `false`.
     *
     * @param bool $reachabilityEnabled Whether the Reachability Indicator feature
     *                                  is enabled for this Conversations Service
     * @return $this Fluent Builder
     */
    public function setReachabilityEnabled(bool $reachabilityEnabled): self {
        $this->options['reachabilityEnabled'] = $reachabilityEnabled;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Conversations.V1.UpdateConfigurationOptions ' . $options . ']';
    }
}